<div class="wrap">
    <h1 class="wp-heading-inline"></h1>
    <hr class="wp-header-end">
    <div class="wrap-body hai-options">
        <form method="post" id="hai-options-form">
            <div class="hai-admin-wrap hai-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                <div class="hai-admin-section hai-admin-sidebar">
                    <div class="hai-admin-head">
                        <svg id="svg" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="400" height="400" viewBox="0, 0, 400,400"><g id="svgg"><path id="path0" d="M141.500 53.415 C 48.540 73.713,24.081 131.879,92.915 168.957 C 97.018 171.167,107.654 176.000,108.415 176.000 C 108.526 176.000,108.600 172.348,108.600 166.892 L 108.600 157.785 106.950 157.057 C 59.377 136.073,60.385 102.200,109.200 81.407 C 114.061 79.337,125.760 75.200,126.755 75.200 C 126.948 75.200,127.000 88.567,127.000 137.892 L 127.000 200.585 127.750 200.784 C 130.749 201.584,136.590 202.955,140.200 203.707 C 142.565 204.200,144.703 204.649,144.950 204.705 L 145.400 204.808 145.400 128.704 C 145.400 86.847,145.333 52.606,145.250 52.614 C 145.167 52.622,143.480 52.983,141.500 53.415 M255.600 101.922 L 255.600 151.251 256.450 151.116 C 258.367 150.813,266.554 148.923,270.150 147.955 L 274.000 146.918 274.000 111.043 L 274.000 75.168 274.650 75.306 C 275.007 75.381,277.415 76.147,280.000 77.006 C 318.496 89.807,336.464 110.731,326.344 130.976 C 311.126 161.421,237.711 180.395,166.750 172.224 L 163.800 171.884 163.800 180.824 L 163.800 189.765 164.550 189.886 C 174.623 191.508,198.920 192.463,213.200 191.799 C 324.309 186.630,384.110 126.014,323.500 79.995 C 307.708 68.004,285.895 59.174,256.050 52.690 L 255.600 52.592 255.600 101.922 M326.600 198.426 C 318.244 203.123,306.735 208.285,296.385 211.980 L 292.500 213.367 292.448 222.683 C 292.419 227.807,292.433 232.000,292.477 232.000 C 292.783 232.000,303.386 228.292,306.535 227.084 C 308.663 226.268,310.493 225.600,310.602 225.600 C 310.732 225.600,310.800 236.664,310.800 257.777 L 310.800 289.954 292.473 302.127 C 282.392 308.822,274.067 314.330,273.973 314.367 C 273.876 314.404,273.800 289.351,273.800 257.539 L 273.800 200.646 270.350 201.518 C 267.018 202.361,259.218 204.123,256.650 204.613 L 255.400 204.852 255.400 275.726 C 255.400 320.127,255.471 346.600,255.589 346.600 C 255.693 346.600,269.801 337.256,286.939 325.836 C 304.078 314.416,320.598 303.425,323.650 301.413 L 329.200 297.753 329.200 247.377 C 329.200 219.669,329.178 197.005,329.150 197.011 C 329.123 197.016,327.975 197.653,326.600 198.426 M71.800 247.465 L 71.800 297.730 108.432 322.115 C 128.579 335.527,145.139 346.530,145.232 346.567 C 145.324 346.603,145.400 326.970,145.400 302.937 L 145.400 259.242 143.550 258.910 C 139.306 258.148,133.100 256.923,130.245 256.284 C 128.564 255.908,127.147 255.600,127.095 255.600 C 127.043 255.600,127.000 268.830,127.000 285.000 C 127.000 301.170,126.962 314.400,126.916 314.400 C 126.870 314.400,118.590 308.909,108.516 302.197 L 90.200 289.993 90.200 257.773 C 90.200 227.181,90.218 225.559,90.550 225.657 C 90.743 225.714,92.835 226.499,95.200 227.400 C 122.152 237.675,149.744 243.301,183.500 245.406 C 197.564 246.283,227.072 245.400,236.288 243.828 L 237.100 243.689 237.152 234.744 C 237.201 226.319,237.184 225.800,236.852 225.802 C 236.658 225.803,235.330 225.933,233.900 226.092 C 230.545 226.463,222.597 227.118,217.500 227.443 C 212.103 227.788,189.105 227.789,183.700 227.446 C 140.979 224.729,104.842 215.240,75.135 198.937 C 73.394 197.982,71.932 197.200,71.885 197.200 C 71.838 197.200,71.800 219.819,71.800 247.465 " stroke="none" fill="#fbfbfb" fill-rule="evenodd"></path><path id="path1" d="M106.000 7.134 C 54.485 10.971,14.133 49.849,8.265 101.300 C 7.917 104.354,7.900 108.842,7.900 199.500 C 7.900 290.158,7.917 294.646,8.265 297.700 C 13.968 347.706,52.094 385.832,102.100 391.535 C 107.079 392.103,293.521 392.103,298.500 391.535 C 348.506 385.832,386.632 347.706,392.335 297.700 C 392.903 292.721,392.903 106.279,392.335 101.300 C 386.669 51.623,349.453 14.042,299.500 7.558 L 296.100 7.117 201.500 7.092 C 149.470 7.078,106.495 7.097,106.000 7.134 M145.400 128.704 L 145.400 204.808 144.950 204.705 C 144.703 204.649,142.565 204.200,140.200 203.707 C 136.590 202.955,130.749 201.584,127.750 200.784 L 127.000 200.585 127.000 137.892 C 127.000 88.567,126.948 75.200,126.755 75.200 C 125.760 75.200,114.061 79.337,109.200 81.407 C 60.385 102.200,59.377 136.073,106.950 157.057 L 108.600 157.785 108.600 166.892 C 108.600 172.348,108.526 176.000,108.415 176.000 C 107.654 176.000,97.018 171.167,92.915 168.957 C 29.077 134.570,44.593 81.338,125.400 57.511 C 130.832 55.909,143.510 52.782,145.250 52.614 C 145.333 52.606,145.400 86.847,145.400 128.704 M261.503 53.893 C 305.264 63.562,337.326 83.965,345.407 107.287 C 360.789 151.680,291.799 191.994,200.437 191.999 C 187.888 192.000,171.796 191.052,164.550 189.886 L 163.800 189.765 163.800 180.824 L 163.800 171.884 166.750 172.224 C 237.711 180.395,311.126 161.421,326.344 130.976 C 336.464 110.731,318.496 89.807,280.000 77.006 C 277.415 76.147,275.007 75.381,274.650 75.306 L 274.000 75.168 274.000 111.043 L 274.000 146.918 270.150 147.955 C 266.554 148.923,258.367 150.813,256.450 151.116 L 255.600 151.251 255.600 101.922 L 255.600 52.592 256.050 52.690 C 256.298 52.744,258.751 53.285,261.503 53.893 M329.200 247.377 L 329.200 297.753 323.650 301.413 C 320.598 303.425,304.078 314.416,286.939 325.836 C 269.801 337.256,255.693 346.600,255.589 346.600 C 255.471 346.600,255.400 320.127,255.400 275.726 L 255.400 204.852 256.650 204.613 C 259.218 204.123,267.018 202.361,270.350 201.518 L 273.800 200.646 273.800 257.539 C 273.800 289.351,273.876 314.404,273.973 314.367 C 274.067 314.330,282.392 308.822,292.473 302.127 L 310.800 289.954 310.800 257.777 C 310.800 236.664,310.732 225.600,310.602 225.600 C 310.493 225.600,308.663 226.268,306.535 227.084 C 303.386 228.292,292.783 232.000,292.477 232.000 C 292.433 232.000,292.419 227.807,292.448 222.683 L 292.500 213.367 296.385 211.980 C 306.735 208.285,318.244 203.123,326.600 198.426 C 327.975 197.653,329.123 197.016,329.150 197.011 C 329.178 197.005,329.200 219.669,329.200 247.377 M75.135 198.937 C 104.842 215.240,140.979 224.729,183.700 227.446 C 189.105 227.789,212.103 227.788,217.500 227.443 C 222.597 227.118,230.545 226.463,233.900 226.092 C 235.330 225.933,236.658 225.803,236.852 225.802 C 237.184 225.800,237.201 226.319,237.152 234.744 L 237.100 243.689 236.288 243.828 C 227.072 245.400,197.564 246.283,183.500 245.406 C 149.744 243.301,122.152 237.675,95.200 227.400 C 92.835 226.499,90.743 225.714,90.550 225.657 C 90.218 225.559,90.200 227.181,90.200 257.773 L 90.200 289.993 108.516 302.197 C 118.590 308.909,126.870 314.400,126.916 314.400 C 126.962 314.400,127.000 301.170,127.000 285.000 C 127.000 268.830,127.043 255.600,127.095 255.600 C 127.147 255.600,128.564 255.908,130.245 256.284 C 133.100 256.923,139.306 258.148,143.550 258.910 L 145.400 259.242 145.400 302.937 C 145.400 326.970,145.324 346.603,145.232 346.567 C 145.139 346.530,128.579 335.527,108.432 322.115 L 71.800 297.730 71.800 247.465 C 71.800 219.819,71.838 197.200,71.885 197.200 C 71.932 197.200,73.394 197.982,75.135 198.937 " stroke="none" fill="#04b4cc" fill-rule="evenodd"></path></g></svg>
                        <h2><?php esc_html_e('Welcome to Hooshina Ai', 'hooshina-ai') ?>👋</h2>
                    </div>
                    <div class="hai-admin-tabs">
                        <ul>
                            <?php foreach(HooshinaAi\App\Settings::get_menu_items() as $key => $item): ?>
                                <li class="<?php echo HooshinaAi\App\Settings::get_current_tab() == $key ? 'active' : '' ?>">
                                    <a href="<?php echo esc_attr(add_query_arg('tab', esc_attr($key), remove_query_arg('subtab'))) ?>">
                                        <?php if(!empty($item['icon'])): ?>
                                            <span class="hai-tab-icon hai-tab-<?php echo esc_attr($key) ?>-icon"></span>
                                        <?php endif; ?>
                                        <?php echo esc_html($item['title']) ?>

                                        <?php 
                                            if(!empty($item['badge'])):
                                                echo sprintf('<span class="hai-tab-item-badge %s">%s</span>', esc_attr($item['badge_classes'] ?? ''), esc_html($item['badge']));
                                            endif; 
                                        ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <div class="hai-admin-section hai-admin-options-wrap">
                    <div class="hai-form-fields-group">
                        <?php if(!\HooshinaAi\App\Connection::isConnected()): ?>
                            <div class="hai-connection-notice">
                                <p><?php esc_html_e('To use all the features of Hoshina Ai, please activate the plugin.', 'hooshina-ai') ?> <a href="<?php echo esc_attr(\HooshinaAi\App\AdminMenu::get_options_url('account')) ?>"><?php esc_html_e('Lets Go', 'hooshina-ai') ?></a></p>
                            </div>
                        <?php endif; ?>
                        <?php HooshinaAi\App\Settings::render_options_content() ?>
                    </div>
                    <?php wp_nonce_field('hooshina_ai_nonce') ?>
                </div>
            </div>
        </form>
    </div>
</div>
